<?php
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/Tag.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecB_impostazioni", 1);
    
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $tag = new Tag($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $tag = new Tag($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $posizione = 0;
            $nomeTagEscape = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES);
            $tag->setNome($nomeTagEscape);
            $tag->setTipo(filter_input(INPUT_POST,"tipo",FILTER_SANITIZE_ADD_SLASHES));
            $tag->setPosizione($posizione);
            $id = $tag->crea();
            echo"<div id=\"divTag$id\" class=\"col-sm-6 col-lg-4\">
                    <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                        <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                            <p class=\"mb-0\"><em><strong>{$tag->getNome()}</strong></em>  </p>
                            <small><em>0 articoli</em></small>
                        </div>
                        <div class=\"azioni d-flex align-items-center justify-content-end\">
                            <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza articoli\" onclick=\"location.href='gestioneContenuti.php?tipo=articolo&idTag={$tag->getId()}';\"><i class=\"fas fa-list\"></i></button>
                                <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaTag({$tag->getId()},'$nomeTagEscape')\"><i class=\"fas fa-edit\"></i></button>
                                <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaTag({$tag->getId()},'$nomeTagEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                            </div>
                       </div>
                    </div>
                </div>";
            break;
        case 'creaDaPaginaCreazioneContenuto':
            $posizione   = 0;
            $idArticolo = filter_input(INPUT_POST,"idArticolo",FILTER_SANITIZE_STRING);
            $tag->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tag->setTipo("articolo");
            $tag->setPosizione($posizione);
            $id = $tag->crea();
            if($id>0) {                
                $tag->associaAdArticolo($idArticolo);
                echo"<div id=\"divTag{$id}\" class=\"d-inline-block mr-2 mb-2\">
                    <button type=\"button\" class=\"btn btn-primary btn-sm round\" onclick=\"eliminaAssociazioneTagArticolo({$id})\">{$tag->getNome()}<i class=\"fas fa-times ml-2\"></i></button>
                </div>";
            }
            else {
                echo "Il tag che vuoi inserire esiste già";
            }
            break;
        case 'modifica':
            $tag->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $tag->modifica();
            echo"ok";
            break;
        case 'aggiornaPosizione':
            $tag->aggiornaPosizione();
            break;
        case 'elimina':
            $tag->elimina();
            echo "ok";
            break;
        case 'stampaElencoTag':
            $query  = "SELECT * FROM `geec_tag` WHERE tipo LIKE 'CMS'";
            $risTag = $geecomDb->eseguiQueryLettura($query);
            
            while($tag = $risTag->fetch_assoc()) {
                $nomeTagEscape = filter_var($tag["nome"],FILTER_SANITIZE_ADD_SLASHES);
                $numeroUtenti  = $geecomDb->contaRigheTabella("geecB_associazioniTagArticoli",array("idTag"=>$tag["id"]));
                echo"<div id=\"divTag{$tag["id"]}\" class=\"col-sm-6 col-lg-4\">
                        <div class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                <p class=\"mb-0\"><em><strong>{$tag["nome"]}</strong></em>  </p>
                                <small><em>$numeroUtenti articoli</em></small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Visualizza articoli\" onclick=\"location.href='gestioneContenuti.php?tipo=articolo&idTag={$tag["id"]}';\"><i class=\"fas fa-list\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Modifica\" onclick=\"modificaTag({$tag["id"]},'$nomeTagEscape}')\"><i class=\"fas fa-edit\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaTag({$tag["id"]},'$nomeTagEscape')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>
                    </div>";
            }
            break;
    }
